/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: UWinVersion.cpp,v 1.3 1999/10/06 06:41:01 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"

#include "UMath.h"
#include "UWinVersion.h"

_USING_PGP

// Functions

PGPBoolean 
UWinVersion::IsWin95Compatible()
{
	switch (GetVersion())
	{
		case kWin95OSR1:
		case kWin95OSR2:
		case kWin98OrFuture:
			return TRUE;

		default:
			return FALSE;
	}
}

PGPBoolean 
UWinVersion::IsWin95OSR2Compatible()
{
	switch (GetVersion())
	{
		case kWin95OSR2:
		case kWin98OrFuture:
			return TRUE;

		default:
			return FALSE;
	}
}

PGPBoolean 
UWinVersion::IsWin98Compatible()
{
	switch (GetVersion())
	{
		case kWin98OrFuture:
			return TRUE;

		default:
			return FALSE;
	}
}

PGPBoolean 
UWinVersion::IsWinNT4Compatible()
{
	switch (GetVersion())
	{
		case kWinNT4NoSp:
		case kWinNT4Sp1:
		case kWinNT4Sp2:
		case kWinNT4Sp3:
		case kWinNT4Sp4:
		case kWinNT4Sp5:
		case kWinNT4PostSp5:
		case kWin2000:
		case kWinPost2000:
			return TRUE;

		default:
			return FALSE;
	}
}

PGPBoolean 
UWinVersion::IsWin2000Compatible()
{
	switch (GetVersion())
	{
		case kWin2000:
		case kWinPost2000:
			return TRUE;

		default:
			return FALSE;
	}
}

UWinVersion::Version 
UWinVersion::GetVersion()
{
	OSVERSIONINFO	verInfo;
	verInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);

	if (!GetVersionEx(&verInfo))
		return kWinUnknown;

	switch (verInfo.dwPlatformId)
	{

	case VER_PLATFORM_WIN32_WINDOWS:
		if (verInfo.dwMinorVersion == 0)
		{
			if (UMath::GetLowWord(verInfo.dwBuildNumber) > 1080)
			{
				return kWin95OSR2;
			}
			else
			{
				return kWin95OSR1;
			}
		}
		else
		{
			return kWin98OrFuture;
		}

	case VER_PLATFORM_WIN32_NT:
		if (verInfo.dwMajorVersion == 3)
		{
			return kWinNT3;
		}
		else if (verInfo.dwMajorVersion == 4)
		{
			if (strlen(verInfo.szCSDVersion) == 0)
			{
				return kWinNT4NoSp;
			}
			else if (strcmp(verInfo.szCSDVersion, "Service Pack 1") == 0)
			{
				return kWinNT4Sp1;
			}
			else if (strcmp(verInfo.szCSDVersion, "Service Pack 2") == 0)
			{
				return kWinNT4Sp2;
			}
			else if (strcmp(verInfo.szCSDVersion, "Service Pack 3") == 0)
			{
				return kWinNT4Sp3;
			}
			else if (strcmp(verInfo.szCSDVersion, "Service Pack 4") == 0)
			{
				return kWinNT4Sp4;
			}
			else if (strcmp(verInfo.szCSDVersion, "Service Pack 5") == 0)
			{
				return kWinNT4Sp5;
			}
			else
			{
				return kWinNT4PostSp5;
			}
		}
		else if (verInfo.dwMajorVersion == 5)
		{
			return kWin2000;
		}
		else
		{
			return kWinPost2000;
		}

	default:
		return kWinUnknown;
	}
}
